import pygame
import random
from car import Car

class Enemycar(Car):
    def __init__(self, position, measures, speed):
        image_path = "assets/enemycar.jpg"
        super().__init__(position, measures, (speed, 0), image_path)
        self.image = pygame.transform.rotate(self.image, 180)

    def move(self, dt):
        self.y += self.speed_vertical * dt
        self.hitbox.topleft = (self.x, self.y)

    @staticmethod
    def spawn(screen_width, width=50, height=100, speed=300):
        x = random.randint(0, screen_width - width)
        y = -height
        return Enemycar((x, y), (width, height), speed)
