import pygame
import sys

class Car:
    def __init__(self, position, measures, stats, image_path):
        self.x, self.y = position
        self.width, self.height = measures
        self.speed_vertical, self.speed_horizontal = stats

        # Hitbox
        self.hitbox = pygame.Rect(self.x, self.y, self.width, self.height)

        # Bild laden und skalieren
        self.image = pygame.image.load(image_path)
        self.image = pygame.transform.scale(self.image, (self.width, self.height))

    def move(self, keys, dt):
        # Links
        if keys[pygame.K_LEFT]:
            self.x -= self.speed_horizontal * dt

        # Rechts
        if keys[pygame.K_RIGHT]:
            self.x += self.speed_horizontal * dt

        # Hoch
        if keys[pygame.K_UP]:
            self.y -= self.speed_vertical * dt

        # Runter
        if keys[pygame.K_DOWN]:
            self.y += self.speed_vertical * dt

        # Hitbox aktualisieren
        self.hitbox.topleft = (self.x, self.y)

    def size(self):
        return self.width * self.height

    def crash(self, other):
        return self.hitbox.colliderect(other.hitbox)

    def draw(self, screen):
        screen.blit(self.image, (self.x, self.y))



    